//
//  SamplePlugIn.m
//  SamplePlugIn
//
//  Created by Kai on 12.1.08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

#import "SamplePlugIn.h"
#import "IBDocument+Private.h"
#import "IBConnection-Private.h"

//-------------------------------------------------------------------------------------------
@implementation SamplePlugIn
//-------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------
- (id) init {
	if ((self = [super init]) != nil) {
		_outletDict = [[NSMutableDictionary alloc] init];
	}
	return self;
}

//-------------------------------------------------------------------------------------------
- (void) dealloc {
	[_outletDict release];
	[super dealloc];
}

//-------------------------------------------------------------------------------------------
- (NSArray*) libraryNibNames {
	return [NSArray arrayWithObject:@"SamplePlugInLibrary"];
}

//-------------------------------------------------------------------------------------------
- (NSString*) label {
	return @"Sample PlugIn";
}

//-------------------------------------------------------------------------------------------
// Tell IB which frameworks are needed for interface simulation.
- (NSArray*) requiredFrameworks {
	NSBundle* frameworkBundle = [NSBundle bundleWithIdentifier:@"de.Hippocampus-Software.SPFramework"];
	return [NSArray arrayWithObject:frameworkBundle];
}

// Outlet Observation -----------------------------------------------------------------------
//-------------------------------------------------------------------------------------------
- (id) checkOutletFor:(id)source
					 label:(NSString*)label
				toObserve:(NSArray*)keyPaths {

	// Get the current destination of the outlet connection, if any.
	id destObject = nil;
	{	IBDocument* doc = [IBDocument documentForObject:source];
		
		NSArray* connections = [doc connectionsFromObject:source];
		for (IBConnection* iConnection in connections) {
			if ([[iConnection label] isEqualToString:label]) {
				if ([iConnection isKindOfClass:[IBConnection/*IBOutletConnection*/ class]])
					 destObject = [iConnection destination];
				else
					NSLog (@"Unexpected connection class %@\n", [iConnection class]);
			}
		}
	}
	
	// Lookup the connection in the repository, using the address of 'source' as key.
	NSNumber* sourceKey = [NSNumber numberWithUnsignedInteger:(NSUInteger)source];
	NSMutableDictionary* outletsInfo = [_outletDict objectForKey:sourceKey];
	if (outletsInfo == nil) {
		if (destObject == nil)
			return destObject;		// nothing to change
		
		// Create the dictionary for this source.
		outletsInfo = [[NSMutableDictionary alloc] initWithCapacity:1];
		[_outletDict setObject:outletsInfo forKey:sourceKey];
		[outletsInfo release];
	}

	id oldDestObject = [outletsInfo objectForKey:label];
	// Update observation if the destination of the connection changed.
	if (destObject != oldDestObject) {
		// Remove old observation(s).
		if (oldDestObject) {
			for (NSString* iKey in keyPaths) {
				[destObject removeObserver:source forKeyPath:iKey];
			}
		}
		
		// Create new observation(s).
		if (destObject) {
			for (NSString* iKey in keyPaths) {
				[destObject addObserver:source forKeyPath:iKey options:0 context:NULL];
			}
			[outletsInfo setObject:destObject forKey:label];
		} else {
			[outletsInfo removeObjectForKey:label];
		}
	}

	return destObject;
}

//-------------------------------------------------------------------------------------------
- (void) removeOutletFor:(id)source
						 label:(NSString*)label
					toObserve:(NSArray*)keyPaths {
	// Lookup the connection in the repository, using the address of 'source' as key.
	NSNumber* sourceKey = [NSNumber numberWithUnsignedInteger:(NSUInteger)source];
	NSMutableDictionary* outletsInfo = [_outletDict objectForKey:sourceKey];
	if (outletsInfo) {
		id destObject = [outletsInfo objectForKey:label];
		// Remove observation(s).
		if (destObject) {
			for (NSString* iKey in keyPaths) {
				[destObject removeObserver:source forKeyPath:iKey];
			}
			[outletsInfo removeObjectForKey:label];
		}
		// Remove the whole info dict if now empty.
		if ([outletsInfo count] == 0)
			[_outletDict removeObjectForKey:sourceKey];
	}
}

@end
